#version 330

const int SampleCount = 11;
const float samples[11] = float[]( 0.01222447, 0.02783468, 0.06559061, 0.12097757, 0.17466632, 0.19741265, 0.17466632, 0.12097757, 0.06559061, 0.02783468, 0.01222447 );
const vec2 pos[11] = vec2[](
#if _VERTICAL
	vec2(0, -5), vec2(0, -4), vec2(0, -3), vec2(0, -2), vec2(0, -1), vec2(0, 0), vec2(0, 1), vec2(0, 2), vec2(0, 3), vec2(0, 4), vec2(0, 5)
#else
	vec2(-5, 0), vec2(-4, 0), vec2(-3, 0), vec2(-2, 0), vec2(-1, 0), vec2(0, 0), vec2(1, 0), vec2(2, 0), vec2(3, 0), vec2(4, 0), vec2(5, 0)
#endif
);

uniform sampler2D tex;
uniform vec4 invTexSize;

in vec4 uv;

out vec4 oColor;

void main()
{
	vec4 sum = vec4(0);
	for (int i = 0; i < SampleCount; i++) {
		sum += textureLod(tex, uv.xy + pos[i]*invTexSize.xy, 0) * samples[i];
	}
	oColor = sum;
}
